package ru.yandex.autotests.direct.web.webelements;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.util.OperationSystemUtils;
import ru.yandex.qatools.htmlelements.element.TextInput;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class NumericInput extends TextInput {
    public NumericInput(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public void click() {
        getWrappedElement().click();
    }

    public String getAttribute(String attributeName) {
        return getWrappedElement().getAttribute(attributeName);
    }

    public String getText() {
        return getWrappedElement().getText();
    }

    @Override
    public void clear() {
        Keys keys = Keys.CONTROL;
        if (OperationSystemUtils.isMac()) {
            keys = Keys.COMMAND;
        }
        getWrappedElement().sendKeys(Keys.chord(keys, "a"));
        getWrappedElement().sendKeys(Keys.DELETE);
    }

    public void setValue(String value) {
        this.clear();
        getWrappedElement().sendKeys(value);
    }

    public String getValue() {
        return getWrappedElement().getAttribute("value");
    }
}
