package ru.yandex.autotests.direct.web.webelements;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.allOf;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.decorators.TimeoutWaiter.timeoutHasExpired;

/**
 * @author shmykov
 *         Селект из наноостровов, пример - страница регистрации в паспорте
 */
public class SelectNanoIslands extends Select {
    public SelectNanoIslands(WebElement wrappedElement) {
        super(wrappedElement);
    }

    protected final String POPUP_XPATH = "//span[contains(@class, '_nb-normal-select-dropdown')]/ul";

    protected WebElement getParent() {
        return getWrappedElement().findElement(By.xpath("./parent::*"));
    }

    protected WebElement getSelectButton() {
        return getWrappedElement().findElement(By.xpath("./parent::span  | ./span"));
    }

    protected boolean isSelectOpened() {
        return getPopupList().getAttribute("style").contains("display: block;");
    }

    protected WebElement getPopupList() {
        return this.getWrappedElement().findElement(By.xpath(POPUP_XPATH));
    }

    protected void openSelect() {
        if (!isSelectOpened()) {
            getSelectButton().click();
        }
        assertThat(getPopupList(), should(allOf(WebElementMatchers.exists(),
                WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(5000)));
    }

    protected void closeSelect() {
        if (isSelectOpened()) {
            getSelectButton().click();
        }
    }

    protected WebElement getPopupOptionByText(String option) {
        return getPopupList().findElement(By.xpath(".//a[text()='" + option + "']"));
    }

    public boolean isDisplayed() {
        return getParent().isDisplayed();
    }

    public List<WebElement> getOptions() {
        return getWrappedElement().findElements(By.tagName("option"));
    }

    public String getSelectedValue() {
        return getWrappedElement().getAttribute("value");
    }

    public String getSelectedText() {
        return getSelectButton().getText();
    }

    public void selectByVisibleText(String text) {
        openSelect();
        getPopupOptionByText(text).click();
    }

    public void selectByValue(String value) {
        for (WebElement option : getOptions()) {
            if (option.getAttribute("value").equals(value)) {
                selectByVisibleText(option.getAttribute("label"));
                return;
            }
        }
        throw new NoSuchElementException("Option with value " + value + " not found");
    }

    public List<String> getOptionsTextList() {
        List<String> result = getOptions().stream().map(option -> option.getAttribute("text")).collect(Collectors.toList());
        return result;
    }

    public boolean isEnabled() {
        return !getParent().getAttribute("class").contains("disabled_yes");
    }

    public List<String> getOptionsValueList() {
        List<String> result = getOptions().stream().map(option -> option.getAttribute("value")).collect(Collectors.toList());
        return result;
    }
}