package ru.yandex.autotests.direct.web.webelements;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.TypifiedElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class TabbedPane extends TypifiedElement {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public TabbedPane(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public List<WebElement> getTabs() {
        return getWrappedElement().findElements(By.xpath(".//li"));
    }

    public void clickTabByText(String text) {
        getTabByText(text).click();
    }

    public WebElement getTabByText(String text) {
        for (WebElement tab : getTabs()) {
            if (tab.findElement(By.xpath("./span")).getText().equals(text)) {
                return tab;
            }
        }
        throw new NoSuchElementException("No tab with text " + text + " found");
    }
}
