package ru.yandex.autotests.direct.web.webelements;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Select;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = ".//div[contains(@class, 'b-vcard-form-worktime__time-row')]")
public class TimePeriodInput extends HtmlElement {
    @Name("Селект дня недели 'с' ")
    @FindBy(xpath = ".//select[contains(@class, 'b-worktime-day__from')]")
    public Select periodStartDaySelect;

    @Name("Селект дня недели 'по' ")
    @FindBy(xpath = ".//select[contains(@class, 'b-worktime-day__to')]")
    public Select periodEndDaySelect;

    @Name("Селект начала 'часы'")
    @FindBy(xpath = ".//select[contains(@class, 'b-worktime-time__hour-from')]")
    public Select periodStartTimeInHoursSelect;

    @Name("Селект начала 'минуты'")
    @FindBy(xpath = ".//select[contains(@class, 'b-worktime-time__min-from')]")
    public Select periodStartTimeInMinutesSelect;

    @Name("Селект конца 'часы'")
    @FindBy(xpath = ".//select[contains(@class, 'b-worktime-time__hour-to')]")
    public Select periodEndTimeInHoursSelect;

    @Name("Селект конца 'минуты'")
    @FindBy(xpath = ".//select[contains(@class, 'b-worktime-time__min-to')]")
    public Select periodEndTimeInMinutesSelect;

    @Name("Ссылка 'ежедневно'")
    @FindBy(xpath = ".//a[contains(@class, 'b-worktime-day__all-week')]")
    public WebElement dailyLink;

    @Name("Ссылка 'круглосуточно'")
    @FindBy(xpath = ".//a[contains(@class, 'b-worktime-time__all-day')]")
    public WebElement roundTheClockLink;

    @Name("Кнопка добавления рабочего времени")
    @FindBy(xpath = ".//div[contains(@class, 'b-worktime-clonator__add')]")
    public WebElement addWorkingTimeButton;

    @Name("Кнопка удаления рабочего времени")
    @FindBy(xpath = ".//div[contains(@class, 'b-worktime-clonator__remove')]")
    public WebElement removeWorkingTimeButton;

    public String getStartTime() {
        return periodStartTimeInHoursSelect.getFirstSelectedOption().getText() + ":"
                + periodStartTimeInMinutesSelect.getFirstSelectedOption().getText();
    }

    public String getEndTime() {
        return periodEndTimeInHoursSelect.getFirstSelectedOption().getText() + ":"
                + periodEndTimeInMinutesSelect.getFirstSelectedOption().getText();
    }

}