package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.Calendar;
import java.util.Date;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.util.DateHelper;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.direct.web.util.helpers.DateParser.parseDate;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class CalendarInputBEM extends TypifiedElement {
    public CalendarInputBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    protected CalendarPopupBlockBEM getPopup() {
        return new CalendarPopupBlockBEM(getWrappedElement().findElement(By.xpath("//div[contains(@class, 'visible')]" +
                "/div[contains(@class, 'popup__content')]/div[contains(@class, 'calendar')]")));
    }

    public WebElement getOpenPopupButton() {
        return getWrappedElement().findElement(By.xpath(".//i[@class='input__calendar']"));
    }

    public void fillDate(Date date) {
        getOpenPopupButton().click();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        selectYear(cal.get(Calendar.YEAR));
        selectMonth(cal.get(Calendar.MONTH));
        getPopup().selectDay(cal.get(Calendar.DAY_OF_MONTH));
    }

    protected void selectYear(int expectedYear) {
        int yearDiff = expectedYear - getPopup().getYear().getValue();
        for (int sign = (int)Math.signum(yearDiff); yearDiff != 0; yearDiff -= sign) {
            if (sign > 0) {
                getPopup().getYear().getSelectNext().click();
            } else {
                getPopup().getYear().getSelectPrev().click();
            }
        }
        assumeThat("выбран ожидаемый год", getPopup().getYear().getValue(), equalTo(expectedYear));
    }

    public void selectMonth(int expectedMonth) {
        int monthDiff = expectedMonth - getPopup().getMonth().getValue();
        for (int sign = (int)Math.signum(monthDiff); monthDiff != 0; monthDiff -= sign) {
            if (sign > 0) {
                getPopup().getMonth().getSelectNext().click();
            } else {
                getPopup().getMonth().getSelectPrev().click();
            }
        }
        assumeThat("выбран ожидаемый месяц", getPopup().getMonth().getValue(), equalTo(expectedMonth));
    }

    public Date getDate() {
        return DateHelper.parseDate(getWrappedElement().findElement(
                By.xpath(".//input[contains(@class, 'b-date-input__hidden')]")).getAttribute("value"));
    }

    protected class CalendarPopupBlockBEM extends TypifiedElement {

        protected CalendarPopupBlockBEM(WebElement wrappedElement) {
            super(wrappedElement);
        }

        protected WebElement getTodayButton() {
            return getWrappedElement()
                    .findElement(By.xpath(".//div[@class = 'calendar__controls']/a[@class='calendar__today']"));
        }

        protected Year getYear() {
            return new Year(getWrappedElement().findElement(
                    By.xpath(".//div[@class='calendar__name'][1]")));
        }

        protected Month getMonth() {
            return new Month(getWrappedElement().findElement(
                    By.xpath(".//div[@class='calendar__name'][2]")));
        }

        protected WebElement getDayOfMonth(int day) {
            return getWrappedElement().findElement(
                    By.xpath(".//td[contains(@class, 'calendar__day') ]" +
                            "/div[@class='calendar__inner' and text() ='" + String.valueOf(day) + "']"));
        }

        public void selectDay(int day) {
            getDayOfMonth(day).click();
        }
    }

    protected class Year extends TypifiedElement {
        protected Year(WebElement wrappedElement) {
            super(wrappedElement);
        }

        protected WebElement getSelectPrev() {
            return getWrappedElement().findElement(
                    By.xpath(".//preceding-sibling::div[contains(@class, 'calendar__arrow-year_direction_left')]"));
        }

        protected WebElement getSelectNext() {
            return getWrappedElement().findElement(
                    By.xpath(".//preceding-sibling::div[contains(@class, 'calendar__arrow-year_direction_right')]"));
        }

        protected int getValue() {
            return Integer.parseInt(getWrappedElement().getText());
        }
    }

    protected class Month extends TypifiedElement {

        protected Month(WebElement wrappedElement) {
            super(wrappedElement);
        }

        protected WebElement getSelectPrev() {
            return getWrappedElement().findElement(
                    By.xpath(".//preceding-sibling::div[contains(@class, 'calendar__arrow_direction_left')]"));
        }

        protected WebElement getSelectNext() {
            return getWrappedElement().findElement(
                    By.xpath(".//preceding-sibling::div[contains(@class, 'calendar__arrow_direction_right')]"));
        }

        protected int getValue() {
            return parseDate(getWrappedElement().getText(), "MMMM").get(Calendar.MONTH);
        }
    }
}
