package ru.yandex.autotests.direct.web.webelements.bem;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@Name("Календарь, используемый в МОЛ")
@FindBy(xpath = ".//div[contains(@class,'super-calendar__untouch') and contains(@style,'visible')]")
public class CalendarReportWizardInputBEM extends HtmlElement {

    @Name("Дата, с которой выводить статистику")
    @FindBy(xpath = ".//input[contains(@class,'super-calendar__from')]")
    private TextInput dateFrom;

    @Name("Дата, по которую выводить статистику")
    @FindBy(xpath = ".//input[contains(@class,'super-calendar__to')]")
    private TextInput dateTo;

    @Name("Кнопка 'Ок'")
    @FindBy(xpath = ".//div[contains(@class,'super-calendar__submit-dates')]//button")
    private Button okButton;

    public void fillDate(Date dateFrom, Date dateTo) {
        Calendar calFrom = Calendar.getInstance();
        calFrom.setTime(dateFrom);
        Calendar calTo = Calendar.getInstance();
        calTo.setTime(dateTo);
        setDates(calFrom, calTo);
    }

    public void setDates(Calendar calendarDateFrom, Calendar calendarDateTo) {
        fillTextInput(dateFrom, String.valueOf(calendarDateFrom.get(Calendar.DAY_OF_MONTH)) + "." +
                //В Calendar месяц число от 0 до 11, а нам надо от 1 до 12, поэтому прибавляем 1
                String.valueOf(calendarDateFrom.get(Calendar.MONTH) + 1) + "." +
                String.valueOf(calendarDateFrom.get(Calendar.YEAR)));
        fillTextInput(dateTo, String.valueOf(calendarDateTo.get(Calendar.DAY_OF_MONTH)) + "." +
                String.valueOf(calendarDateTo.get(Calendar.MONTH) + 1) + "." +
                String.valueOf(calendarDateTo.get(Calendar.YEAR)));
        clickOk();
    }

    public Pair<Date, Date> getDatePeriod() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
        try {
            return ImmutablePair.of(dateFormat.parse(dateFrom.getText()), dateFormat.parse(dateTo.getText()));
        } catch (ParseException e) {
            throw new DirectWebError("Ошибка при конвертации даты", e);
        }
    }

    public void clickOk() {
        okButton.click();
    }
}
