package ru.yandex.autotests.direct.web.webelements.bem;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.CheckBox;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class CheckBoxBEM extends CheckBox {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public CheckBoxBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public boolean isDisplayed() {
        return getWrappedElement().findElement(By.xpath("./..")).isDisplayed();
    }

    /**
     * Finds label corresponding to this checkbox using "following::label[1]" xpath (first label after "input").
     *
     * @return {@code WebElement} representing label or {@code null} if no label has been found.
     */
    @Override
    public WebElement getLabel() {
        try {
            return getWrappedElement().findElement(By.xpath("following::label[1]"));
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean isSelected() {
        if (getWrappedElement().getTagName().contains("input")) {
            return getWrappedElement().isSelected();
        } else {
            return getWrappedElement().findElement(By.xpath(".//input")).isSelected();
        }
    }

    @Override
    public void select() {
        if (!isSelected()) {
            getWrappedElement().click();
        }
    }

    /**
     * Deselects checkbox if it is not already deselected.
     */
    @Override
    public void deselect() {
        if (isSelected()) {
            getWrappedElement().click();
        }
    }
}