package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;

public class ClientTransferSelectBEM extends ExtendedHtmlElement {

    @Name("Список клиентов")
    @FindBy(css = "div.select__item > span")
    public List<WebElement> clientList;

    public void selectClient(String value) {
        clientList.stream().filter(client -> client.getText().contains(value + " ")).findFirst()
                .orElseThrow(() -> new DirectWebError("Не найден клиент " + value))
                .click();
    }
}