package ru.yandex.autotests.direct.web.webelements.bem;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

import ru.yandex.qatools.htmlelements.element.FileInput;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;

import static ru.yandex.qatools.htmlelements.utils.HtmlElementUtils.existsInClasspath;
import static ru.yandex.qatools.htmlelements.utils.HtmlElementUtils.getResourceFromClasspath;

public class FileInputBEM extends FileInput {

    public FileInputBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public static boolean isRemoteWebElement(WebElement element) {
        return element instanceof RemoteWebElement;
    }

    public static WebElement getRemoteWebElement(WebElement element) {
        WebElement result = element;
        try {
            Method privateMethod = result.getClass().
                    getDeclaredMethod("getWrappedElement");
            privateMethod.setAccessible(true);
            result = (WebElement) privateMethod.invoke(result);
        } catch (Exception ignored) {

        }
        return result;
    }

    //From HtmlElementsUtils.isOnRemoteWebDriver
    public static boolean isOnRemoteWebDriver(WebElement element) {
        if (!isRemoteWebElement(element)) {
            return false;
        }

        RemoteWebElement remoteWebElement = (RemoteWebElement) element;
        try {
            Field elementParentFiled = RemoteWebElement.class.getDeclaredField("parent");
            elementParentFiled.setAccessible(true);
            WebDriver elementParent = (WebDriver) elementParentFiled.get(remoteWebElement);
            return elementParent instanceof RemoteWebDriver;
        } catch (NoSuchFieldException e) {
            throw new HtmlElementsException("Unable to find out if WebElement is on remote driver", e);
        } catch (IllegalAccessException e) {
            throw new HtmlElementsException("Unable to find out if WebElement is on remote driver", e);
        }
    }

    private void setLocalFileDetector(RemoteWebElement element) {
        element.setFileDetector(new LocalFileDetector());
    }

    private String getPathForResource(final String fileName) {
        return getResourceFromClasspath(fileName).getPath();
    }

    private String getPathForSystemFile(final String fileName) {
        File file = new File(fileName);
        return file.getPath();
    }

    private String getFilePath(final String fileName) {
        if (existsInClasspath(fileName)) {
            return getPathForResource(fileName);
        }
        return getPathForSystemFile(fileName);
    }

    @Override
    public void setFileToUpload(final String fileName) {
        // Proxy can't be used to check the element class, so find real WebElement
        WebElement fileInputElement = getRemoteWebElement(getWrappedElement().findElement(By.xpath(".")));
        // Set local file detector in case of remote driver usage
        if (isOnRemoteWebDriver(fileInputElement)) {
            setLocalFileDetector((RemoteWebElement) fileInputElement);
        }

        String filePath = getFilePath(fileName);
        fileInputElement.sendKeys(filePath);
    }
}
