package ru.yandex.autotests.direct.web.webelements.bem;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Created by shmykov on 17.06.14.
 */
public class HoursPeriodInputBEM extends HtmlElement {
    private static final int DAY_COUNT = 7;

    @Name("Селект начала 'часы'")
    @FindBy(xpath = ".//span[contains(@class, 'b-worktime__hour-from')]//select")
    public SelectBEM periodStartTimeInHoursSelect;

    @Name("Селект начала 'минуты'")
    @FindBy(xpath = ".//span[contains(@class, 'b-worktime__min-from')]//select")
    public SelectBEM periodStartTimeInMinutesSelect;

    @Name("Селект конца 'часы'")
    @FindBy(xpath = ".//span[contains(@class, 'b-worktime__hour-to')]//select")
    public SelectBEM periodEndTimeInHoursSelect;

    @Name("Селект конца 'минуты'")
    @FindBy(xpath = ".//span[contains(@class, 'b-worktime__min-to')]//select")
    public SelectBEM periodEndTimeInMinutesSelect;

    public String getStartTime() {
        return periodStartTimeInHoursSelect.getSelectedText() + ":"
                + periodStartTimeInMinutesSelect.getSelectedText();
    }

    public String getEndTime() {
        return periodEndTimeInHoursSelect.getSelectedText()  + ":"
                + periodEndTimeInMinutesSelect.getSelectedText();
    }

}
