package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.Select;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 24.11.14
 */
public class ListBoxBEM extends Select {

    public ListBoxBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    protected final String POPUP_XPATH = "./following-sibling::div[contains(@class, 'select__popup')]" +
            "//div[@class='select__list']";

    protected WebElement getParent() {
        return getWrappedElement().findElement(By.xpath("./parent::*"));
    }

    protected WebElement getSelectButton() {
        return getWrappedElement().findElement(By.xpath("./preceding-sibling::button  | ./button"));
    }

    protected WebElement getPopupList() {
        return this.getWrappedElement().findElement(By.xpath(POPUP_XPATH));
    }

    protected WebElement getPopupOptionByText(String option) {
        return getPopupList().findElement(By.xpath(".//div[contains(@class, 'select__item')]" +
                "[./span[text()='" + option + "']]"));
    }

    public boolean isDisplayed() {
        return getParent().isDisplayed();
    }

    public List<WebElement> getOptions() {
        return getWrappedElement().findElements(By.tagName("option"));
    }

    public String getSelectedText() {
        return getSelectButton().getText();
    }

    public void selectByVisibleText(String text) {
        getPopupOptionByText(text).click();
    }

    public void selectByValue(String value) {
        for (WebElement option : getOptions()) {
            if (option.getAttribute("value").equals(value)) {
                selectByVisibleText(option.getAttribute("text"));
                return;
            }
        }
        throw new NoSuchElementException("Option with value " + value + " not found");
    }

    public boolean isEnabled() {
        return !getParent().getAttribute("class").contains("disabled_yes");
    }

}
