package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.MobileBannerAdditionalEnum;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;

@FindBy(xpath = "//div[contains(@class, 'popup2_visible_yes')]")
public class MobileAppAdditionsSelect extends ExtendedHtmlElement {

    public void selectValues(List<MobileBannerAdditionalEnum> values) {
        uncheckAllValues();
        values.stream().forEach(v -> selectValue(v));
    }

    private List<WebElement> getValues() {
        return findElements(By.xpath(
                "//div[contains(@class, 'b-mobile-content-additions__model-field') "
                        + "and contains(@class, 'menu__item_type_option')]"));
    }

    private void selectValue(MobileBannerAdditionalEnum value) {
        getValues().stream()
                .filter(v -> v.findElement(By.xpath(".//span[contains(@class, 'menu__text')]")).getText().equals(value.getValue()))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдено значение: " + value.getValue()))
                .click();
    }

    public void uncheckAllValues() {
        getValues().stream().forEach(v -> {
            if(v.getAttribute("class").contains("menu__item_checked_yes")) {
                v.click();
            }
        });
    }
}