package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.Radio;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class RadioBEM extends Radio {
    /**
     * Specifies a radio button of a radio button group that will be used to find all other buttons of this group.
     *
     * @param wrappedElement {@code WebElement} representing radio button.
     */
    public RadioBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    @Override
    public void selectByValue(String value) {
        selectButton(getButton(value));
    }

    @Override
    public WebElement getWrappedElement() {
        return super.getWrappedElement().findElement(By.xpath("parent::*"));
    }

    @Override
    public List<WebElement> getButtons() {
        String radioName = super.getWrappedElement().getAttribute("name");

        String xpath;
        if (radioName == null || radioName.isEmpty()) {
            xpath = "self::* | following::input[@type = 'radio'] | preceding::input[@type = 'radio']";
        } else {
            xpath = String.format(
                    "self::* | following::input[@type = 'radio' and @name = '%s'] | " +
                            "preceding::input[@type = 'radio' and @name = '%s']",
                    radioName, radioName
            );
        }

        return super.getWrappedElement().findElements(By.xpath(xpath));
    }

    //Возвращает кнопку с соответствующим значением value и которой соответствует видимый родительский span
    private WebElement getButton(String value) {
        for (WebElement button : getButtons()) {
            String buttonValue = button.getAttribute("value");
            if (value.equals(buttonValue) && button.findElement(By.xpath("parent::*")).isDisplayed()) {
                return button;
            }
        }
        throw new NoSuchElementException(String.format("Cannot locate radio button with value: %s", value));
    }

    private void selectButton(WebElement button) {
        if (!button.isSelected()) {
            button.findElement(By.xpath("parent::*")).click();
        }
    }

    public String getSelectedValue() {
        return getSelectedButton().getAttribute("value");
    }
}