package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

/**
 * @author alex-samo
 *
 */
public class RetargetingRadioBlockBEM extends RadioBEM {
    /**
     * Specifies a radio button of a radio button group that will be used to find all other buttons of this group.
     *
     * @param wrappedElement {@code WebElement} representing radio button.
     */
    public RetargetingRadioBlockBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    @Override
    public WebElement getSelectedButton() {
        for (WebElement button : getButtons()) {
            if (button.isSelected() || button.findElement(By.xpath("parent::*")).getAttribute("class").
                    contains("radio-button__radio_checked_yes")) {
                return button;
            }
        }

        throw new NoSuchElementException("No selected button");
    }

    @Override
    public List<WebElement> getButtons() {
        return getWrappedElement().findElements(By.xpath(".//input[@type = 'radio']"));
    }
}