package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class SelectBlockBEM extends SelectBEM {

    public SelectBlockBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    protected String getPopupListXpath() {
        return "//div[contains(@class, 'popup_visibility_visible') and not(contains(@class, 'b-infoblock'))]";
    }

    @Override
    protected WebElement getPopupList() {
        return this.getWrappedElement().findElement(By.xpath(getPopupListXpath()));
    }

    @Override
    protected WebElement getPopupOptionByText(String option) {
        return getPopupList().findElement(By.xpath(".//div[contains(@class, 'b-chooser__item')]" +
                "[./div[text()='" + option + "']]"));
    }

    @Override
    public List<WebElement> getOptions() {
        return getPopupList().findElements(By.xpath(".//div[contains(@class, 'b-chooser__item')]"));
    }

    @Override
    protected boolean isSelectOpened() {
        WebElement button = getSelectButton();
        return button.getAttribute("aria-expanded").contains("true");
    }

    @Override
    public void selectByValue(String value) {
        openSelect();
        for (WebElement option : getOptions()) {
            if (option.getAttribute("data-bem").contains("\"name\":\"" + value + "\"")) {
                option.click();
                return;
            }
        }
        throw new NoSuchElementException("Option with value " + value + " not found");
    }

    @Override
    public String getSelectedValue() {
        openSelect();
        WebElement selectedElem = getOptions().stream()
                .filter(t -> t.getAttribute("class").contains("b-chooser__item_selected_yes"))
                .findFirst()
                .orElseThrow(null);
        if (selectedElem != null) {
            String value = selectedElem.getText();
            closeSelect();
            return value;
        }
        closeSelect();
        return null;
    }

    @Override
    protected WebElement getSelectButton() {
        return getWrappedElement().findElement(By.xpath("./preceding-sibling::button  | .//button"));
    }
}
