package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.TypifiedElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class TabbedPaneBEM extends TypifiedElement {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public TabbedPaneBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public List<WebElement> getTabs() {
        return getWrappedElement().findElements(By.xpath("./li//span[@data-bem]"));
    }

    public void clickTabByText(String text) {
        getTabByText(text).click();
    }

    public WebElement getTabByText(String text) {
        for (WebElement tab : getTabs()) {
            if (tab.getText().equals(text)) {
                return tab;
            }
        }
        throw new NoSuchElementException("No tab with text " + text + " found");
    }
}