package ru.yandex.autotests.direct.web.webelements.bem;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 30.05.14
 */
@FindBy(xpath = ".//tr[contains(@class, 'b-form-worktime__row')]")
public class TimePeriodInputBEM extends HtmlElement{

    private static final int DAY_COUNT = 7;

    @Name("Дни недели")
    @FindBy(xpath = ".//div[@class='b-form-worktime__days']//input")
    private List<CheckBoxBEM> dayCheckBoxes;

    @Name("Селект начала 'часы'")
    @FindBy(xpath = "(.//div[@class='b-form-worktime__time']//select)[1]")
    private SelectBEM startHoursSelect;

    @Name("Селект начала 'минуты'")
    @FindBy(xpath = "(.//div[@class='b-form-worktime__time']//select)[2]")
    private SelectBEM startMinutesSelect;

    @Name("Селект конца 'часы'")
    @FindBy(xpath = "(.//div[@class='b-form-worktime__time']//select)[3]")
    private SelectBEM endHoursSelect;

    @Name("Селект конца 'минуты'")
    @FindBy(xpath = "(.//div[@class='b-form-worktime__time']//select)[4]")
    private SelectBEM endMinutesSelect;

    @Name("Кнопка добавления рабочего времени")
    @FindBy(css = "span.b-form-worktime__link_action_add")
    private WebElement addWorkingTimeButton;

    @Name("Кнопка удаления рабочего времени")
    @FindBy(css = "span.b-form-worktime__link_action_remove")
    private WebElement removeWorkingTimeButton;

    private void addPeriodWithTimeToValueList(int startDayNumber, int endDayNumber, LinkedList<String> valuesList) {
        valuesList.add(String.valueOf(startDayNumber));
        valuesList.add(String.valueOf(endDayNumber));
        valuesList.add(startHoursSelect.getSelectedText());
        valuesList.add(startMinutesSelect.getSelectedText());
        valuesList.add(endHoursSelect.getSelectedText());
        valuesList.add(endMinutesSelect.getSelectedText());
    }

    private Integer getEndOfDayInterval(Integer startDay) {
        Integer position = startDay;
        while (position < DAY_COUNT && dayCheckBoxes.get(position).isSelected()) {
            ++position;
        }
        return position - 1;
    }

    public String getWorkTime() {
        LinkedList<String> valuesList = new LinkedList<>();
        Integer currentPosition = 0;
        while (currentPosition < DAY_COUNT) {
            if (dayCheckBoxes.get(currentPosition).isSelected()) {
                Integer endOfDayInterval = getEndOfDayInterval(currentPosition);
                addPeriodWithTimeToValueList(currentPosition, endOfDayInterval, valuesList);
                currentPosition = endOfDayInterval + 1;
            } else {
                ++currentPosition;
            }
        }
        return StringUtils.join(valuesList, ";")
                .replaceAll("(0)(\\d)", "$2"); //replace all 0d number to d (d - digit), for example 00->0, 08->8
    }

    private void fillDayPeriod(String startDayNumber, String endDayNumber) {
        for (int dayNumber = 0; dayNumber < DAY_COUNT; ++dayNumber) {
            if (dayNumber >= Integer.valueOf(startDayNumber) && dayNumber <= Integer.valueOf(endDayNumber)) {
                dayCheckBoxes.get(dayNumber).select();
            } else {
                dayCheckBoxes.get(dayNumber).deselect();
            }
        }
    }

    //period - строка вида d;d;hh;mm;hh;mm; или null
    public void fillWorkTime(String period) {
        if (period == null)
            return;
        String[] timeValues = period.split(";");
        fillDayPeriod(timeValues[0], timeValues[1]);
        if (timeValues[2].length() == 1) {
            timeValues[2] = "0" + timeValues[2];
        }
        fillSelect(startHoursSelect, timeValues[2], SelectInputMethod.BY_TEXT);
        if (timeValues[3].equals("0")) {
            timeValues[3] = "00";
        }
        fillSelect(startMinutesSelect, timeValues[3], SelectInputMethod.BY_TEXT);
        if (timeValues[4].length() == 1) {
            timeValues[4] += "0";
        }
        fillSelect(endHoursSelect, timeValues[4], SelectInputMethod.BY_TEXT);
        if (timeValues[5].equals("0")) {
            timeValues[5] = "00";
        }
        fillSelect(endMinutesSelect, timeValues[5], SelectInputMethod.BY_TEXT);
    }

    public void clickOnAddWorkingTimeButton() {
        addWorkingTimeButton.click();
    }

    public void clickOnRemoveWorkingTimeButton() {
        removeWorkingTimeButton.click();
    }
}