package ru.yandex.autotests.direct.steps;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

@Resource.Classpath("xls.properties")
public class XlsTestProperties {
    private static final String PROJECT = "PROJECT";
    private static final XlsTestProperties instance = new XlsTestProperties();

    @Property("xls.islocalrun")
    private Boolean isLocalRun = false;

    @Property("xls.outputdir")
    private String outputDir = PROJECT;

    @Property("b2b.beta1.stage")
    private String stage1 = "8080";

    @Property("b2b.beta2.stage")
    private String stage2 = "8999";

    @Property("xls.isdebug")
    private Boolean isDebug = false;

    private XlsTestProperties() {
        PropertyLoader.populate(this);
    }

    public static XlsTestProperties getXlsTestProperties() {
        return instance;
    }

    public Boolean isLocalRun() {
        return isLocalRun;
    }

    public String getOutputDir() {
        return outputDir == PROJECT ? System.getProperty("user.dir") : outputDir;
    }

    public String getBeta1() {
        return DirectTestRunProperties.getInstance().resolveDirectStageTypeToHost(stage1);
    }

    public String getBeta2() {
        return DirectTestRunProperties.getInstance().resolveDirectStageTypeToHost(stage2);
    }

    public String getStage1() {
        return stage1;
    }

    public String getStage2() {
        return stage2;
    }

    public Boolean isDebug() {
        return isDebug;
    }
}
