package ru.yandex.autotests.direct.steps.matchers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

import org.apache.commons.collections4.ListUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.autotests.direct.steps.utils.TableDiffer;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;

import static ru.yandex.autotests.direct.steps.XlsTestProperties.getXlsTestProperties;
import static ru.yandex.autotests.direct.steps.utils.TableDiffer.addLocalAttachment;

public class TableDifferMatcher extends TypeSafeMatcher<List<List<String>>> {
    private final Logger log = LoggerFactory.getLogger(TableDifferMatcher.class);

    private List<List<String>> expectedList;

    public TableDifferMatcher(List<List<String>> bean) {
        this.expectedList = bean;
    }

    @Override
    protected boolean matchesSafely(List<List<String>> actualList) {
        boolean isSame = true;
        if (actualList == expectedList) {
            isSame = true;
        } else if (actualList.size() != expectedList.size()) {
            isSame = false;
        } else {
            int size = actualList.size();
            for (int i = 0; i < size; i++) {
                if (!ListUtils.isEqualList(expectedList, actualList)) {
                    isSame = false;
                    break;
                }
            }
        }
        return isSame;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("tables are equals");
    }

    @Override
    protected void describeMismatchSafely(List<List<String>> item, Description mismatchDescription) {
        mismatchDescription.appendText("tables are not equals");
        Workbook workbook = new TableDiffer().getXlsxDiffFile(expectedList, item);
        if (getXlsTestProperties().isLocalRun()) {
            addLocalAttachment(workbook, log);
        } else {
            addAllureAttachment(workbook);
        }
    }

    private void addAllureAttachment(Workbook wb) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            wb.write(bos);
            AllureUtils.addXlsxAttachment("Файл различий", bos.toByteArray());
        } catch (IOException e) {
            AllureUtils.addTextAttachment("Не удалось прикрепить файл различий", e.getMessage());
        }
    }


    public static TypeSafeMatcher<List<List<String>>> equalToTable(List<List<String>> bean) {
        return new TableDifferMatcher(bean);
    }
}
