package ru.yandex.autotests.direct.steps.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import static java.util.stream.Collectors.toList;

public class Converters {
    public static List<List<String>> tableFromFirstExcelSheet(File source) {
        return tableFromExcel(source, 0);
    }

    public static List<List<String>> tableFromExcel(File source, int sheetIndex) {
        try (Workbook wb = WorkbookFactory.create(source)) {
            Sheet sheet = wb.getSheetAt(sheetIndex);
            List<List<String>> result = new ArrayList<>(sheet.getLastRowNum());
            DataFormatter dataFormatter = new DataFormatter();
            for (Row row : sheet) {
                List<String> currentRow = new ArrayList<>(row.getLastCellNum());
                result.add(currentRow);
                for (Cell cell : row) {
                    currentRow.add(dataFormatter.formatCellValue(cell));
                }
            }
            return result;
        } catch (Exception e) {
            throw new IllegalStateException("Ошибка при чтении Xls файла", e);
        }
    }

    public static List<List<String>> tableFromCsv(File source) {
        try (CSVParser parser = CSVParser.parse(source, StandardCharsets.UTF_8, CSVFormat.newFormat(';'))) {
            return parser.getRecords().stream()
                    .map(x -> {
                        ArrayList<String> result = new ArrayList<>(x.size());
                        for (String value : x) {
                            result.add(value);
                        }
                        return result;
                    })
                    .collect(toList());
        } catch (IOException e) {
            throw new IllegalStateException("Ошибка при чтении csv файла", e);
        }
    }
}
