package ru.yandex.autotests.direct.steps.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;

import static java.util.stream.Collectors.toList;

public class ListUtils {
    public static void sortRowsByCellValues(List<List<String>>... lists) {
        sortLists((x, y) -> {
            int minLen = Math.min(x.size(), y.size());
            for (int i = 0; i < minLen; i++) {
                int comparisonResult = x.get(i).compareTo(y.get(i));
                if (comparisonResult != 0) {
                    return comparisonResult;
                }
            }
            return x.size() == y.size() ? 0 :
                    x.size() == minLen ? -1 : +1; // longest win
        }, lists);
    }

    public static <T> void sortLists(Comparator<T> comporator, List<T>... lists) {
        for (List<T> list : lists) {
            list.sort(comporator);
        }
    }

    public static <T> String joining(T... values) {
        return StringUtils.join(values, ",");
    }

    public static <T> Collection<Object[]> paramsToArrays(T... values) {
        return Stream.of(values)
                .map(x -> new Object[]{x})
                .collect(toList());
    }
}
