package ru.yandex.autotests.direct.steps.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.google.common.base.Preconditions;

import ru.yandex.autotests.direct.cmd.data.showcampstat.ShowCampStatRequest;

import static ru.yandex.autotests.direct.cmd.data.showcampstat.StatGroupEnum.DAY;
import static ru.yandex.autotests.direct.utils.model.PerlBoolean.NO;
import static ru.yandex.autotests.direct.utils.model.PerlBoolean.YES;

public class ShowCampStatRequestBuilder {
    private final Pattern datePattern = Pattern.compile("^(\\d{2})-(\\d{2})-(\\d{4})$");
    private ShowCampStatRequest request;

    public ShowCampStatRequestBuilder(ShowCampStatRequest request) {
        this.request = request;
    }

    public static ShowCampStatRequestBuilder requestBuilder(ShowCampStatRequest request) {
        return new ShowCampStatRequestBuilder(request);
    }

    public ShowCampStatRequestBuilder dateFrom(String dateFrom) {
        Matcher matcher = checkDateFormatAndGetMatcher(dateFrom);
        request.withD1(matcher.group(1))
                .withM1(matcher.group(2))
                .withY1(matcher.group(3));
        return this;
    }

    public ShowCampStatRequestBuilder dateTo(String dateTo) {
        Matcher matcher = checkDateFormatAndGetMatcher(dateTo);
        request.withD2(matcher.group(1))
                .withM2(matcher.group(2))
                .withY2(matcher.group(3));
        return this;
    }

    public ShowCampStatRequest get() {
        return request;
    }

    private Matcher checkDateFormatAndGetMatcher(String date) {
        Matcher matcher = datePattern.matcher(date);
        Preconditions.checkArgument(matcher.matches(),
                "дата должна соответствовать формату dd-mm-yyyy");
        return matcher;
    }
}
