package ru.yandex.autotests.directapi.banners;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_ACCESS_TO_DEPRECATED_V4LIVE;
import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_ACCESS_TO_DEPRECATED_V4_AND_LIVE;
import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_NO_SPECIAL_ACCESS;

/**
 * Created by hmepas on 10.08.16.
 */

@Aqua.Test
//@Features(BannerFeatures.DEPRECATED_METHODS)
// Возможно позже понадобится как пример
@Features(BannerFeatures.NOT_REGRESSION_YET)
@Description("Проверка что закрытые методы API4 и API4Live действительно закрыты, независимо от настроек доступа на приложении")
@Issue("https://st.yandex-team.ru/DIRECT-57137")
@RunWith(Parameterized.class)
public class ClosedMethodsTest {
    public static final int APIV4 = 4;
    public static final int API_V4_Live = 104;
    @ClassRule
    public static ApiSteps api = new ApiSteps();
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    public final AxisError deprecatedError = new AxisError(509);
    @Parameterized.Parameter(0)
    public Method method;

    @Parameterized.Parameter(1)
    public int apiVersion;

    @Parameterized.Parameters(name = "method {0} in API Version {1}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                // По две записи на метод закрытый в обоих версиях
                {Method.GET_BANNERS, APIV4},
                {Method.GET_BANNERS, API_V4_Live}
        });
    }

    @Test
    public void methodClosedForNonSpecialApplications() {
        checkForCredentials(apiVersion, method, HAS_NO_SPECIAL_ACCESS,
                "доступ к " + method.toString() + " в версии " + apiVersion + "закрыт для приложений без специальных настроек доступа к устаревшим методам");

    }

    @Test
    public void methodClosedForApplicationsWithAccessToV4DeprecatedMethods() {
        checkForCredentials(apiVersion, method, HAS_ACCESS_TO_DEPRECATED_V4_AND_LIVE,
                "доступ к " + method.toString() + " в версии " + apiVersion + "закрыт для приложений без специальных настроек доступа к устаревшим методам");
    }

    @Test
    public void methodClosedForApplicationsWithAccessToV4LiveDeprecatedMethods() {
        checkForCredentials(apiVersion, method, HAS_ACCESS_TO_DEPRECATED_V4LIVE,
                "доступ к " + method.toString() + " в версии " + apiVersion + "закрыт для приложений без специальных настроек доступа к устаревшим методам");
    }

    private void checkForCredentials(int apiVersion, Method method, ApiAccessCredentials credentials, String message) {
        api.version(apiVersion)
                .as(credentials.getLogin())
                .applicationID(credentials.getApplicationId())
                .userSteps.shouldGetErrorOn(
                message
                , method.toString()
                , new Object()
                , deprecatedError);
    }

}
