package ru.yandex.autotests.directapi.banners;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.AuthenticationData.PERSISTENT_TOKEN_CREDENTIALS;

/**
 * Created by hmepas on 28.08.16.
 * https://st.yandex-team.ru/TESTIRT-10143
 */

@Aqua.Test
//@Features(BannerFeatures.DEPRECATED_METHODS)
// Возможно позже понадобится как пример
@Features(BannerFeatures.NOT_REGRESSION_YET)
@Description("Проверка доступа с persistent_token-ом к методам отключенным, но еще доступным по галочке")
@Issue("https://st.yandex-team.ru/DIRECT-57780")
public class PersistentTokenAccessToSemiDeprecatedMethodsTest {
    /*  То, что методы действительно закрыты, будет проверено в теста
        SpecialApplicationsAccessToSemiDeprecatedMethodsInV4LiveTest
        SpecialApplicationsAccessToSemiDeprecatedMethodsInV4Test

        см. описание постоянных токенов в  ./proteсted/API/Settings.pm
    */
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static MongoUser user;

    @BeforeClass
    public static void init() {
        user = MongoUser.get(PERSISTENT_TOKEN_CREDENTIALS.getLogin());
    }

    @Test
    public void persistentTokenHasAccessToSemiDeprecatedV4Methods() {
        api.version(4)
                .as(PERSISTENT_TOKEN_CREDENTIALS.getLogin())
                .token("")
                // Persistent token хранится в поле sandboxToken
                .persistentToken(user.getSandboxToken())
                .userSteps.shouldGetErrorOn(
                "по persistent_token-у есть доступ к закрытым методам 4ой версии"
                , Method.GET_BANNER_PHRASES.toString()
                , new Object()
                , new AxisError(9, AxisErrorDetails.THE_BANNERIDS_FIELD_MUST_BE_AN_ARRAY));
    }

    @Test
    public void persistentTokenHasAccessToSemiDeprecatedV4LiveMethods() {
        api.version(104)
                .as(PERSISTENT_TOKEN_CREDENTIALS.getLogin())
                .token("")
                // Persistent token хранится в поле sandboxToken
                .persistentToken(user.getSandboxToken())
                .userSteps.shouldGetErrorOn(
                "по persistent_token-у есть доступ к закрытым методам 4Live версии"
                , Method.GET_BANNER_PHRASES.toString()
                , new Object()
                , new AxisError(9, AxisErrorDetails.THE_BANNERIDS_FIELD_MUST_BE_AN_ARRAY));
    }
}
