package ru.yandex.autotests.directapi.banners;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.campaigns.GetCampaignsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_ACCESS_TO_DEPRECATED_V4LIVE;
import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_NO_SPECIAL_ACCESS;

/**
 * Created by hmepas on 10.08.16.
 * https://st.yandex-team.ru/DIRECT-56971
 */

@Aqua.Test
//@Features(BannerFeatures.DEPRECATED_METHODS)
// Возможно позже понадобится как пример
@Features(BannerFeatures.NOT_REGRESSION_YET)
@Description("Проверка доступа к устаревшим методам API версии 4Live")
@Issue("https://st.yandex-team.ru/DIRECT-57137")
@RunWith(Parameterized.class)
public class SpecialApplicationsAccessToSemiDeprecatedMethodsInV4LiveTest {
    public static final ApiAccessCredentials HAS_ACCESS_4LIVE_ONLY = HAS_ACCESS_TO_DEPRECATED_V4LIVE;
    public static final ApiAccessCredentials HAS_NO_ACCESS = HAS_NO_SPECIAL_ACCESS;
    public static final int DEPRECATED_IN_VERSION = 104;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(DEPRECATED_IN_VERSION);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Method method;

    @Parameterized.Parameter(1)
    public Object requestParameters;

    /* Ошибка валидации, специфичная для запроса. Показывает что пройдена авторизация,
       проверка доступа и метод существует. Это дешевле чем создавать честные данные и проверять успех вызова на них */
    @Parameterized.Parameter(2)
    public AxisError requestErrorWhenHasAccessToDeprecatedMethod;

    @Parameterized.Parameters(name = "method {0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {Method.CREATE_OR_UPDATE_CAMPAIGN, new Object(), new AxisError(501)},
                {Method.GET_CAMPAIGNS_LIST, new Object(), new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY, "Logins")},
                {Method.GET_CAMPAIGNS_LIST_FILTER, new GetCampaignsInfoMap(api.type()).withLogins(""), new AxisError(251, AxisErrorDetails.THE_FIELD_SHOULD_BE_AN_ARRAY_OF_VALID_USERNAMES, "Logins")},
                {Method.GET_CAMPAIGNS_PARAMS, new Object(), new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY, "CampaignIDS")},
                {Method.GET_CAMPAIGN_PARAMS, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.DELETE_CAMPAIGN, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.RESUME_CAMPAIGN, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.STOP_CAMPAIGN, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.ARCHIVE_CAMPAIGN, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.UNARCHIVE_CAMPAIGN, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.CREATE_OR_UPDATE_BANNERS, new Object(), new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY, "ArrayOfBannerInfo")},
                {Method.GET_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.BANNERIDS_OR_CAMPAIGNIDS_MUST_NOT_BE_EMPTY)},
                {Method.DELETE_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "BannerIDS")},
                {Method.MODERATE_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED, "CampaignID", "BannerIDS")},
                {Method.RESUME_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "BannerIDS")},
                {Method.STOP_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "BannerIDS")},
                {Method.ARCHIVE_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "BannerIDS")},
                {Method.UNARCHIVE_BANNERS, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "BannerIDS")},
                {Method.KEYWORD, new Object(), new AxisError(501, AxisErrorDetails.INVALID_ACTION)},
                {Method.GET_BANNER_PHRASES, new Object()
                        , new AxisError(9, AxisErrorDetails.THE_BANNERIDS_FIELD_MUST_BE_AN_ARRAY)},
                {Method.GET_BANNER_PHRASES_FILTER, new Object()
                        , new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "BannerIDS")},
                {Method.SET_AUTO_PRICE, new Object(), new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "CampaignID")},
                {Method.UPDATE_PRICES, new Object(), new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY, "")},
        });
    }

    @Test
    public void noAccessForApplicationsWithoutSpecialPermissions() {
        api.applicationID(HAS_NO_ACCESS.getApplicationId())
                .as(HAS_NO_ACCESS.getLogin())
                .userSteps.shouldGetErrorOn("нет доступа к устаревшему в 4Live версии методу" + method.toString()
                , method.toString(), new Object(), new AxisError(509));
    }

    @Test
    public void hasAccessWith4LiveOnlyPermission() {
        api.applicationID(HAS_ACCESS_4LIVE_ONLY.getApplicationId())
                .as(HAS_ACCESS_4LIVE_ONLY.getLogin())
                .userSteps.shouldGetErrorOn("есть доступ к устаревшему в 4Live версии методу" + method.toString()
                        + "для приложения с доступам к 4Live устаревшим методам, но без доступа к методам устарешим в 4-ой версии"
                , method.toString(), requestParameters, requestErrorWhenHasAccessToDeprecatedMethod);
    }

    // провеку что доступ для приложения с галочкой доступа к 4-ой версии произведут обычные тесты на метод
    // public void hasAccessWithV4DeprecatedEnabled() {
}
