package ru.yandex.autotests.directapi.banners;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_ACCESS_TO_DEPRECATED_V4LIVE;
import static ru.yandex.autotests.directapi.model.AuthenticationData.HAS_NO_SPECIAL_ACCESS;

/**
 * Created by hmepas on 10.08.16.
 * https://st.yandex-team.ru/TESTIRT-10045
 */

@Aqua.Test
//@Features(BannerFeatures.DEPRECATED_METHODS)
// Возможно позже понадобится как пример
@Features(BannerFeatures.NOT_REGRESSION_YET)
@Description("Проверка доступа к устаревшим методам API версии 4")
@Issue("https://st.yandex-team.ru/DIRECT-56971")
@RunWith(Parameterized.class)
public class SpecialApplicationsAccessToSemiDeprecatedMethodsInV4Test {
    public static final ApiAccessCredentials HAS_NO_ACCESS_BUT_V4LIVE = HAS_ACCESS_TO_DEPRECATED_V4LIVE;
    public static final ApiAccessCredentials HAS_NO_ACCESS = HAS_NO_SPECIAL_ACCESS;
    public static final int DEPRECATED_IN_VERSION = 4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(DEPRECATED_IN_VERSION);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Method method;

    @Parameterized.Parameters(name = "method {0}")
    public static Collection<Method[]> testData() {
        return Arrays.asList(new Method[][]{
                {Method.GET_BANNER_PHRASES},
                {Method.CREATE_OR_UPDATE_CAMPAIGN},
                {Method.GET_CAMPAIGNS_LIST},
                {Method.GET_CAMPAIGNS_LIST_FILTER},
                {Method.GET_CAMPAIGNS_PARAMS},
                {Method.GET_CAMPAIGN_PARAMS},
                {Method.DELETE_CAMPAIGN},
                {Method.RESUME_CAMPAIGN},
                {Method.STOP_CAMPAIGN},
                {Method.ARCHIVE_CAMPAIGN},
                {Method.UNARCHIVE_CAMPAIGN},
                {Method.CREATE_OR_UPDATE_BANNERS},
                {Method.GET_BANNERS},
                {Method.DELETE_BANNERS},
                {Method.MODERATE_BANNERS},
                {Method.RESUME_BANNERS},
                {Method.STOP_BANNERS},
                {Method.ARCHIVE_BANNERS},
                {Method.UNARCHIVE_BANNERS},
                {Method.GET_BANNER_PHRASES_FILTER},
                {Method.SET_AUTO_PRICE},
                {Method.UPDATE_PRICES},
        });
    }

    @Test
    public void noAccessForApplicationsWithoutSpecialPermissions() {
        api.applicationID(HAS_NO_ACCESS.getApplicationId())
                .as(HAS_NO_ACCESS.getLogin())
                .userSteps.shouldGetErrorOn("нет доступа к устаревшему в 4-ой версии методу" + method.toString()
                , method.toString(), new Object(), new AxisError(509));
    }

    @Test
    public void noAccessWithV4LiveOnlySpecialPermission() {
        api.applicationID(HAS_NO_ACCESS_BUT_V4LIVE.getApplicationId())
                .as(HAS_NO_ACCESS_BUT_V4LIVE.getLogin())
                .userSteps.shouldGetErrorOn("нет доступа к устаревшему в 4-ой версии методу"
                        + method.toString() + "для приложения с галочкой доступа к устаревшим в 4Live версии методам",
                method.toString(), new Object(), new AxisError(509));
    }

    // public void hasAccessWithV4DeprecatedEnabled() { .. провеку что доступ есть произведут обычные тесты на метод
}
