package ru.yandex.autotests.directapi.banners.getrubrics;


import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

/**
 * Created with IntelliJ IDEA.
 * User: ginger
 * Date: 28.10.13
 * Time: 4:10
 * To change this template use File | Settings | File Templates.
 */
// https://jira.yandex-team.ru/browse/TESTIRT-1108
@Aqua.Test
@Features(BannerFeatures.GET_RUBRICS)
@Stories(ApiStories.REMOVE_RUBRICS)
@Tag(TagDictionary.TRUNK)
public class GetRubricsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8232")
    public void getRubricsJsonTest() {
        Object[] rubrics = api.userSteps.getRubricsSteps().getRubrics();
        assertThat("Список рубрик пуст",rubrics,not(equalTo(new Object[]{})));
    }
}
