package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignBidsInfo;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: xy6er
 * https://jira.yandex-team.ru/browse/TESTIRT-1368
 */

@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Stories(ApiStories.ARCHIVE)
@Tag(TagDictionary.TRUNK)
public class ModerateArchiveBannersTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static Long campaignId;
    private static Long adId;

    private static String login = BannerLogins.CLIENT_SELF;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().setAPIUnits(login, 120000);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.addCompletedAdGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8358")
    public void shouldGetErrorOnModerateBannersFromArchiveCampaignTest() {
        log.info("Должны получить ошибку 156 - при отправке на модерацию баннеров архивной кампании");
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        api.userSteps.campaignSteps().campaignsArchive(campaignId);
        api.userSteps.bannerSteps().shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(new CampaignBidsInfo()).withBannerIDS(adId),
                new AxisError(156, AxisErrorDetails.CAMPAIGN_ARCHIVED_WITH_ID, campaignId));
    }
}
