package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Description("Автоматическая отправка объявлений на модерацию")
public class ModerateBannersAutoModerateTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaingId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        campaingId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Description("Объявления из одной группы вызовом ModerateBanners на одно из объявлений отправляются на модерацию все")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8360")
    public void sameAdGroupBannerCreatedBeforeModerate() {
        Long[] ads = api.userSteps.addCompletedAdGroupWithTwoAds(campaingId);
        api.userSteps.bannerSteps().moderateBanner(ads[0]);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(ads[1]);
        assertThat("объявление не отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }
}
