package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/7/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersBannerIDLengthRestrictionTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @Title("Длина массива " + CampaignBidsInfoMap.BANNER_IDS + " равна " + CampaignBidsInfoMap.MAX_BANNER_IDS_LENGTH)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8361")
    public void maxBannerIDSLength() {
        Long[] bannerIDS = new Long[CampaignBidsInfoMap.MAX_BANNER_IDS_LENGTH];
        Arrays.fill(bannerIDS, 0l);
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(bannerIDS).getBean(),
                new AxisError(27));
    }

    @Test
    @Title("Длина массива " + CampaignBidsInfoMap.BANNER_IDS + " больше " + CampaignBidsInfoMap.MAX_BANNER_IDS_LENGTH)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8362")
    public void greaterThanMaxBannerIDSLength() {
        Long[] bannerIDS = new Long[CampaignBidsInfoMap.MAX_BANNER_IDS_LENGTH + 1];
        Arrays.fill(bannerIDS, 0l);
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(bannerIDS).getBean(),
                new AxisError(241, AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        capitalize(CampaignBidsInfoMap.BANNER_IDS), CampaignBidsInfoMap.MAX_BANNER_IDS_LENGTH));
    }
}
