package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/7/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersFieldsValidationTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private Long adId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createBanner() {
        adId = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Запрос без " + CampaignBidsInfoMap.CAMPAIGN_ID + " и " + CampaignBidsInfoMap.BANNER_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8365")
    public void requestWithoutCampaignIDAndBannerIDS() {
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .getBean(),
                new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
                        capitalize(CampaignBidsInfoMap.CAMPAIGN_ID), capitalize(CampaignBidsInfoMap.BANNER_IDS)));
    }

    @Test
    @Title("Нулевое значение в " + CampaignBidsInfoMap.CAMPAIGN_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8364")
    public void zeroValueInCampaignID() {
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withCampaignID(0).getBean(),
                new AxisError(1));
    }

    @Test
    @Title("Отрицательное значение в " + CampaignBidsInfoMap.CAMPAIGN_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8366")
    public void negativeValueInCampaignID() {
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withCampaignID(-13).getBean(),
                new AxisError(1));
    }

    @Test
    @Title("Нулевое значение в " + CampaignBidsInfoMap.BANNER_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8367")
    public void zeroValueInBannerIDS() {
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(new Long[]{adId, 0l}).getBean(),
                new AxisError(27));
    }
}
