package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 02.11.15.
 * https://st.yandex-team.ru/TESTIRT-7576
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-46327")
@Description("Вызов модерации объявлений для объявлений из двух разных кампаний")
public class ModerateBannersForDifferentCampaignsTest {

    private static final String LOGIN = BannerLogins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId1;
    private Long adId2;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        long campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adId1 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId1);
        long campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adId2 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId2);
    }

    @Test
    @Description("Модерация двух баннеров из разных кампаний")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8866")
    public void moderateTwoBannersFromDifferentCampaigns() {
        int response = api.userSteps.bannerSteps().moderateBanners(adId1, adId2);
        assertThat("в ответе вернулась единица", response, equalTo(1));
    }
}
