package ru.yandex.autotests.directapi.banners.moderatebanners;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 18.09.13
 * Time: 17:22
 * https://jira.yandex-team.ru/browse/TESTIRT-982
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Stories(ApiStories.GROUPS)
public class ModerateBannersInGroupTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BannerLogins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long firstBannerInGroup;
    private static Long secondBannerInGroup;

    @BeforeClass
    public static void testCampaign() {
        api.userSteps.clientFakeSteps().setAPIUnits(login, 120000);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long[] bannerIDs = api.userSteps.addCompletedAdGroupWithTwoAds(campaignId);
        firstBannerInGroup = bannerIDs[0];
        secondBannerInGroup = bannerIDs[1];
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8369")
    public void moderateBannersTest() {
        log.info("Проверяем, что оба баннера имеют статус модерации New");
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(firstBannerInGroup);
        TestSteps.assertThat("объявление не отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(
                Status.NEW));

        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(secondBannerInGroup);
        TestSteps.assertThat("объявление не отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(
                Status.NEW));

        log.info("Отправляем на модерацию один баннер из группы");
        api.userSteps.bannerSteps().moderateBanner(firstBannerInGroup);

        log.info("Проверяем, что на модерацию отправились оба баннера из группы");
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(firstBannerInGroup);
        TestSteps.assertThat("объявление не отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(
                Status.READY));

        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(secondBannerInGroup);
        TestSteps.assertThat("объявление не отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(
                Status.READY));

    }
}
