package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/7/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersJsonValidationTest {

    private static final String STRING_VALUE = "SomeStringValue";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adId = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title(CampaignBidsInfoMap.CAMPAIGN_ID + " имеет тип массива")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8372")
    public void campaignIDOfArrayType() {
        JSONObject request = new JSONObject();
        request.put(CampaignBidsInfoMap.CAMPAIGN_ID, new Long[]{campaignId});
        request.put(CampaignBidsInfoMap.BANNER_IDS, new Long[]{adId});
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS, request,
                new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
                        capitalize(CampaignBidsInfoMap.CAMPAIGN_ID), capitalize(CampaignBidsInfoMap.BANNER_IDS)));
    }

    @Test
    @Title(CampaignBidsInfoMap.CAMPAIGN_ID + " имеет тип строки")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8370")
    public void campaignIDOfStringType() {
        JSONObject request = new JSONObject();
        request.put(CampaignBidsInfoMap.CAMPAIGN_ID, STRING_VALUE);
        request.put(CampaignBidsInfoMap.BANNER_IDS, new Long[]{adId});
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS, request,
                new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
                        capitalize(CampaignBidsInfoMap.CAMPAIGN_ID), capitalize(CampaignBidsInfoMap.BANNER_IDS)));
    }

    @Test
    @Title(CampaignBidsInfoMap.BANNER_IDS + " имеет тип целого числа")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8371")
    public void bannerIDSOfIntegerType() {
        JSONObject request = new JSONObject();
        request.put(CampaignBidsInfoMap.CAMPAIGN_ID, campaignId);
        request.put(CampaignBidsInfoMap.BANNER_IDS, adId);
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS, request,
                new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
                        capitalize(CampaignBidsInfoMap.CAMPAIGN_ID), capitalize(CampaignBidsInfoMap.BANNER_IDS)));
    }

    @Test
    @Title(CampaignBidsInfoMap.BANNER_IDS + " содержит значения типа массива")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8374")
    public void bannerIDSContainsElementsOfArrayType() {
        JSONObject request = new JSONObject();
        request.put(CampaignBidsInfoMap.CAMPAIGN_ID, campaignId);
        request.put(CampaignBidsInfoMap.BANNER_IDS, new Long[][]{new Long[]{adId}});
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS, request,
                new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
                        capitalize(CampaignBidsInfoMap.CAMPAIGN_ID), capitalize(CampaignBidsInfoMap.BANNER_IDS)));
    }

    @Test
    @Title(CampaignBidsInfoMap.BANNER_IDS + " содержит значения типа строки")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8373")
    public void bannerIDSContainsElementsOfStringType() {
        JSONObject request = new JSONObject();
        request.put(CampaignBidsInfoMap.CAMPAIGN_ID, campaignId);
        request.put(CampaignBidsInfoMap.BANNER_IDS, new Object[]{adId, STRING_VALUE});
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS, request,
                new AxisError(71, AxisErrorDetails.ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
                        capitalize(CampaignBidsInfoMap.CAMPAIGN_ID), capitalize(CampaignBidsInfoMap.BANNER_IDS)));
    }
}
