package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/7/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@Features(BannerFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class ModerateBannersNegativeTestFailed {

    private static final String LOGIN = BannerLogins.CLIENT_SELF;

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adId = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
//    @Title("Чужая кампания без баннера")
    @Title("DIRECT-36544")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8382")
    public void campaignWhichDoesNotBelongToLoginWithoutBanner() {
        String otherLogin = BannerLogins.LOGIN_FOR_RUB;
        assumeThat("логины не равны", LOGIN, not(equalTo(otherLogin)));

        api.as(otherLogin);
        Long otherCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();

        api.as(LOGIN);
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withCampaignID(otherCampaignID).getBean(),
                new AxisError(54));
    }
}
