package ru.yandex.autotests.directapi.banners.moderatebanners;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 11/7/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Tag(TagDictionary.TRUNK)
public class ModerateBannersTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Test
    @Title("Кампания без баннеров")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8391")
    public void campaignWithoutBanners() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int response = api.userSteps.bannerSteps().moderateBanners(new CampaignBidsInfoMap(api.type())
                .withCampaignID(campaignId));
        assertThat("ответ метода равен нулю", response, equalTo(0));
    }

    @Test
    @Title("Кампания с баннером-черновиком")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8389")
    public void campaignWithDraftBanner() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        int response = api.userSteps.bannerSteps().moderateBanners(new CampaignBidsInfoMap(api.type())
                .withCampaignID(campaignId));
        assertThat("ответ метода равен единице", response, equalTo(1));
    }

    @Test
    @Title("Кампания с баннерами с разными статусами")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8390")
    public void campaignWithVariousStatusBanners() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        log.info("Создать баннер-черновик");
        Long draftBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);

        log.info("Создать активный баннер");
        Long activeBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.bannersFakeSteps().makeBannersActiveAndFullyModerated(activeBannerID);

        log.info("Содать баннер на модерации");
        Long pendingBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.bannerSteps().moderateBanner(pendingBannerID);

        log.info("Создать промодерированный баннер");
        Long moderatedBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(activeBannerID);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(moderatedBannerID);

        log.info("Создать отклоненный на модерации баннер");
        Long declinedBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.bannersFakeSteps().makeBannersDeclined(declinedBannerID);

        api.userSteps.bannerSteps().moderateBanners(new CampaignBidsInfoMap(api.type())
                .withCampaignID(campaignId));


        final GetResponse adsGetResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS)
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignId)));

        assertThat("статус модерации изменился только у баннера черновика", adsGetResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(draftBannerID).withStatus(StatusEnum.MODERATION).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(activeBannerID).withStatus(StatusEnum.ACCEPTED).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(pendingBannerID).withStatus(StatusEnum.MODERATION).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(moderatedBannerID).withStatus(StatusEnum.ACCEPTED).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(declinedBannerID).withStatus(StatusEnum.REJECTED).getBean()
                )));
    }
}
