package ru.yandex.autotests.directapi.banners.moderatebanners;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 26.07.16.
 * https://st.yandex-team.ru/TESTIRT-9782
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-54756")
@Description("Отправка на модерацию графического баннера")
public class ModerateImageAdTest {

    private static final String LOGIN = BannerLogins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textCampaignId;
    private static Long textImageAdId;
    private static Long mobileAppCampaignId;
    private static Long mobileAppImageAdId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void prepareData() {
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(7);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(textAdGroupId);
        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
        mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(mobileAppAdGroupId);
        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
    }

    @Test
    public void moderateTextImageAd() {
        int result = api.userSteps.bannerSteps().moderateBanners(
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(textImageAdId)
        );
        assertThat("архивация выполнилась успешно", result, equalTo(1));
    }

    @Test
    public void moderateMobileAppImageAd() {
        int result = api.userSteps.bannerSteps().moderateBanners(
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(mobileAppImageAdId)
        );
        assertThat("архивация выполнилась успешно", result, equalTo(1));
    }
}
