package ru.yandex.autotests.directapi.banners.moderatebanners.roles;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersExternalRolesRightsNegativeTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String apiUserLogin;

    @Parameterized.Parameter(value = 1)
    public String createCampaignLogin;

    @Parameterized.Parameter(value = 2)
    public String campaignOwnerLogin;

    private Long campaignId;
    private Long adId;

    @Parameterized.Parameters(name = "Вызов метода от: {0}, владелец кампании: {2}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {BannerLogins.AGENCY_SHARD_2, BannerLogins.AGENCY, BannerLogins.SUB_CLIENT_DEFAULT},
                {BannerLogins.MANAGER_DEFAULT, BannerLogins.SUPER_LOGIN, BannerLogins.CLIENT_SELF},
                {BannerLogins.CLIENT_SELF_REP, BannerLogins.SUPER_LOGIN, BannerLogins.CLIENT_FOR_RUB},
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(createCampaignLogin).clientLogin(campaignOwnerLogin);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adgroupId = api.userSteps.addCompletedAdGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adgroupId);
        api.clientLogin(null);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8392")
    public void checkModerateBannersResponse() {
        api.as(apiUserLogin);
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(adId).getBean(),
                new AxisError(54));
    }
}
