package ru.yandex.autotests.directapi.banners.moderatebanners.roles;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersExternalRolesRightsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String apiUserLogin;

    @Parameterized.Parameter(value = 1)
    public String campaignOwnerLogin;

    private Long campaignId;
    private Long adId;

    @Parameterized.Parameters(name = "Вызов метода от: {0}, владелец кампании: {1}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {BannerLogins.AGENCY, BannerLogins.SUB_CLIENT_DEFAULT},
                {BannerLogins.MANAGER_DEFAULT, Logins.LOGIN_FOR_RUB},
                {BannerLogins.CLIENT_SELF_REP, BannerLogins.CLIENT_SELF},
                {BannerLogins.AGENCY_REP, BannerLogins.SUB_CLIENT_DEFAULT}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(apiUserLogin).clientLogin(campaignOwnerLogin);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adgroupId = api.userSteps.addCompletedAdGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adgroupId);
        api.clientLogin(null);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8393")
    public void checkModerateBannersResponse() {
        int response = api.userSteps.bannerSteps().moderateBanner(adId);
        assertThat("успешный вызов метода", response, equalTo(1));
    }
}
