package ru.yandex.autotests.directapi.banners.moderatebanners.roles;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3249
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersInternalRolesRightsNegativeTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String login;

    private Long campaignId;
    private Long adId;

    @Parameterized.Parameters(name = "Логин пользователя: {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {Logins.MEDIA},
                {Logins.SUPER_READER}
        });
    }

    @Before
    @Step("Подгтовка данных для теста")
    public void createCampaign() {
        api.as(BannerLogins.CLIENT_SELF);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adgroupId = api.userSteps.addCompletedAdGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adgroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8394")
    public void checkModerateBannersResponse() {
        api.as(login);
        api.userSteps.shouldGetErrorOn(
                Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap(api.type())
                        .withBannerIDS(adId),
                new AxisError(54));
    }
}
