package ru.yandex.autotests.directapi.banners.moderatebanners.sharding;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 31.01.14.
 */

@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Stories(ApiStories.SHARDING)
public class ModerateBannersInBothShardTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static String AGENCY_LOGIN = BannerLogins.AGENCY_SHARD_2;
    private static String SC_SHARD1 = BannerLogins.SC_AGENCY_SHARD_2_1;
    private static String SC_SHARD2 = BannerLogins.SC_AGENCY_SHARD_2_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long firstShardAdId;
    private Long secondShardAdId;

    @BeforeClass
    public static void shardLogins() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(AGENCY_LOGIN, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(SC_SHARD1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(SC_SHARD2, ShardNumbers.EXTRA_SHARD);
    }

	@Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        Long firstShardcampaignId = api.clientLogin(SC_SHARD1).userSteps.campaignSteps().addDefaultTextCampaign(SC_SHARD1);
        Long secondShardcampaignId = api.clientLogin(SC_SHARD2).userSteps.campaignSteps().addDefaultTextCampaign(SC_SHARD2);

        Long firstShardAdgroupId = api.clientLogin(SC_SHARD1).userSteps.addCompletedAdGroup(firstShardcampaignId);
        Long secondShardAdgroupId = api.clientLogin(SC_SHARD2).userSteps.addCompletedAdGroup(secondShardcampaignId);

        firstShardAdId = api.clientLogin(SC_SHARD1).userSteps.adsSteps().addDefaultTextAd(firstShardAdgroupId);
        secondShardAdId = api.clientLogin(SC_SHARD2).userSteps.adsSteps().addDefaultTextAd(secondShardAdgroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8396")
    public void successModerateBannersInBothShardTest() {
        CampaignBidsInfoMap campaignBidsInfoMap = new CampaignBidsInfoMap(api.type());
        api.clientLogin(null).userSteps.bannerSteps().moderateBanners(
                campaignBidsInfoMap.withBannerIDS(firstShardAdId, secondShardAdId)
        );

        BannerFakeInfo fakeBannerParams = api.userSteps.bannersFakeSteps().getBannerParams(firstShardAdId);
        assertThat("баннер отправился на модерацию", fakeBannerParams.getStatusModerate(), equalTo(Status.READY));
        fakeBannerParams = api.userSteps.bannersFakeSteps().getBannerParams(firstShardAdId);
        assertThat("баннер является черновиком", fakeBannerParams.getStatusModerate(), equalTo(Status.READY));
    }

}
