package ru.yandex.autotests.directapi.banners.moderatebanners.sharding;


import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 24.01.14.
 * https://jira.yandex-team.ru/browse/DIRECT-27458
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Stories(ApiStories.SHARDING)
@RunWith(Parameterized.class)
public class ModerateBannersPositiveTest {
    private static Long campaignId;
    private static Long adId;

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String operatorForCreateData;

    @Parameterized.Parameter(value = 2)
    public String client;


    @Parameterized.Parameters(name = "Operator = {0}, Client = {2}")
    public static Collection roles(){
       Object[][] data = new Object[][]{
               {BannerLogins.AGENCY_SHARD_2, BannerLogins.AGENCY_SHARD_2, BannerLogins.SC_AGENCY_SHARD_2_2},
               {BannerLogins.AGENCY_SHARD_2, BannerLogins.AGENCY_SHARD_2, BannerLogins.SC_AGENCY_SHARD_2_1},
               {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT,Logins.SERVICED_CLIENT_IN_2_SHARD},
       };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void shardUsers(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(BannerLogins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(BannerLogins.SC_AGENCY_SHARD_2_1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(BannerLogins.SC_AGENCY_SHARD_2_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(BannerLogins.SERVICED_CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
    }

	@Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(operatorForCreateData).clientLogin(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adgroupId = api.userSteps.addCompletedAdGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adgroupId);
        api.as(operator).clientLogin(null);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8398")
    public void moderateBannersByBannerIDShouldBeSuccess() {
        CampaignBidsInfoMap params = new CampaignBidsInfoMap(api.type());
        params.withBannerIDS(adId);
        api.userSteps.bannerSteps().moderateBanners(params);
        log.info("Объявление отправлено на модерацию");
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8399")
    public void moderateBannersByCampaignIDShouldBeSuccess() {
        CampaignBidsInfoMap params = new CampaignBidsInfoMap(api.type());
        params.withCampaignID(campaignId);
        api.userSteps.bannerSteps().moderateBanners(params);
        log.info("Объявление отправлено на модерацию");
    }
}
