package ru.yandex.autotests.directapi.banners.moderatebanners.statuses;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 9/30/14.
 * https://st.yandex-team.ru/TESTIRT-2907
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Stories(ApiStories.STATUS_MODERATE)
@Tag(TagDictionary.TRUNK)
public class ModerateBannersCampaignStatusModerateTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long firstBannerID;

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        firstBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8402")
    public void campaignShouldBeOnModerationIfOneBannerOnModeration() {
        api.userSteps.bannerSteps().moderateBanner(firstBannerID);
        final CampaignGetItem campaignGetItem = api.userSteps.campaignSteps().getCampaign(campaignId);
        assertThat("кампания на модерации",
                campaignGetItem.getStatus(), equalTo(StatusEnum.MODERATION));
    }
}
