package ru.yandex.autotests.directapi.banners.moderatebanners.statuses;

import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.model.banners.CampaignBidsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.UserSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 9/30/14.
 * https://st.yandex-team.ru/TESTIRT-2901
 */
@Aqua.Test
@Features(BannerFeatures.MODERATE_BANNERS)
@Stories(ApiStories.STATUS_MODERATE)
@Tag(TagDictionary.TRUNK)
public class ModerateBannersStatusModerateTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerId;
    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        final UserSteps.AdGroupCreationResult adGroupCreationResult =
                api.userSteps.addCompletedAdGroupAndReturnCreationResult(campaignId);
        bannerId = adGroupCreationResult.getAdIds()[0];
        adGroupId = adGroupCreationResult.getAdGroupId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8409")
    public void moderateBannersForDraftBanner() {
        api.userSteps.bannerSteps().moderateBanner(bannerId);

        final BannerFakeInfo bannerParams = api.userSteps.bannersFakeSteps().getBannerParams(bannerId);
        BannerFakeInfo expectedResult = new BannerFakeInfo();
        expectedResult.setStatusArch(null);
        expectedResult.setStatusModerate("Ready");
        expectedResult.setPhoneFlag("New");
        expectedResult.setStatusSitelinksModerate("New");

        final List<AdGroupGetItem> adGroupGetItems = api.userSteps.adGroupsSteps().adGroupsGetById(adGroupId);
        assertThat("Группа на модерации", adGroupGetItems.get(0).getStatus(),
                equalTo(StatusEnum.MODERATION));
        assertThat("результат соответствует ожидаемому", bannerParams,
                beanDiffer(expectedResult).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8410")
    public void moderateDraftBannerForCampaignWithTwoBanners() {
        final UserSteps.AdGroupCreationResult adGroupCreationResult =
                api.userSteps.addCompletedAdGroupAndReturnCreationResult(campaignId);
        Long anotherBannerID = adGroupCreationResult.getAdIds()[0];
        Long anotheradGroupId = adGroupCreationResult.getAdGroupId();
        api.userSteps.bannerSteps().moderateBanner(bannerId);
        final BannerFakeInfo bannerParams = api.userSteps.bannersFakeSteps().getBannerParams(anotherBannerID);
        BannerFakeInfo expectedResult = new BannerFakeInfo();
        expectedResult.setStatusArch(null);
        expectedResult.setStatusModerate("New");
        expectedResult.setPhoneFlag("New");
        expectedResult.setStatusSitelinksModerate("New");

        final List<AdGroupGetItem> adGroupGetItems = api.userSteps.adGroupsSteps().adGroupsGetById(anotheradGroupId);
        assertThat("Группа в статусе черновик", adGroupGetItems.get(0).getStatus(),
            equalTo(StatusEnum.DRAFT));
        assertThat("результат соответствует ожидаемому", bannerParams,
                beanDiffer(expectedResult).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8407")
    public void moderateBannersForBannerOnModeration() {
        api.userSteps.bannerSteps().moderateBanner(bannerId);
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap<>(api.type())
                        .withBannerIDS(bannerId)
                        .getBean(),
                new AxisError(155, AxisErrorDetails.BANNER_MUST_BE_DRAFT));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8406")
    public void moderateBannersForModeratedBanner() {
        api.userSteps.bannersFakeSteps().makeBannersModerated(bannerId);
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap<>(api.type())
                        .withBannerIDS(bannerId)
                        .getBean(),
                new AxisError(155, AxisErrorDetails.BANNER_MUST_BE_DRAFT));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8405")
    public void moderateBannersForActiveBanner() {
        api.userSteps.bannersFakeSteps().makeBannerActive(bannerId);
        api.userSteps.shouldGetErrorOn(Method.MODERATE_BANNERS,
                new CampaignBidsInfoMap<>(api.type())
                        .withBannerIDS(bannerId)
                        .getBean(),
                new AxisError(155, AxisErrorDetails.BANNER_MUST_BE_DRAFT));
    }
}
