package ru.yandex.autotests.directapi.banners.moderatebanners.statuses;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerInfo;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;
import ru.yandex.autotests.directapi.model.common.StatusModerate;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 9/30/14.
 * https://st.yandex-team.ru/TESTIRT-2901
 */
@Aqua.Test
@Features(BannerFeatures.BUG)
@Stories(ApiStories.STATUS_MODERATE)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class ModerateBannersStatusModerateTestFailed {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int campaignID;
    private Long bannerID;

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        campaignID = api.userSteps.campaignStepsV4().createDefaultCampaign();
        bannerID = api.userSteps.bannerSteps().createDefaultBanner(campaignID);
    }

    @Test
    @Title("DIRECT-35582")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8411")
    public void moderateBannersForArchiveBanner() {
        api.userSteps.bannerSteps().stopBanner(bannerID);
        api.userSteps.bannerSteps().archiveBanner(bannerID);
        api.userSteps.bannerSteps().moderateBanner(bannerID);
        BannerInfo actualResult = api.userSteps.bannerSteps().getBanner(bannerID);
        BannerInfo expectedResult = (BannerInfo) new BannerInfoMap(api.type())
                .withStatusArchive(StatusModerate.YES)
                .withStatusBannerModerate(StatusModerate.NEW)
                .withStatusPhrasesModerate(StatusModerate.NEW)
                .withStatusPhoneModerate(StatusModerate.NEW)
                .withStatusSiteLinksModerate(StatusModerate.NEW).getBean();
        assertThat("результат соответствует ожидаемому", actualResult, beanEquals(expectedResult));
    }
}
