package ru.yandex.autotests.directapi.banners.production;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 29.04.14.
 * <p/>
 * Smoke-тесты на проверку некоторых методов на production окружении
 * https://jira.yandex-team.ru/browse/TESTIRT-1800
 */
@Aqua.Test
@Features(ApiFeatures.PRODUCTION)
@Stories(BannerFeatures.MODERATE_BANNERS)
public class ModerateBannersProdTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = Logins.CLIENT_SMOKE_PROD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin);

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adId1;
    private static Long adId2;

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long[] adIds = api.userSteps.addCompletedAdGroupWithTwoAds(campaignId);
        adId1 = adIds[0];
        adId2 = adIds[1];
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8412")
    public void moderateBannersTest() {
        log.info("Проверяем, что оба баннера имеют статус модерации New");

        BannerFakeInfo fakeBannerParams = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("баннер является черновиком", fakeBannerParams.getStatusModerate(), equalTo(Status.NEW));
        fakeBannerParams = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("баннер является черновиком", fakeBannerParams.getStatusModerate(), equalTo(Status.NEW));

        log.info("Отправляем на модерацию один баннер из группы");
        api.userSteps.bannerSteps().moderateBanner(adId1);
        final GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS)
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId1, adId2)));


        Assert.assertThat("вернулось два объявления в статусе MODERATION", getResponse.getAds(), beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(adId1).withStatus(StatusEnum.MODERATION).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adId2).withStatus(StatusEnum.MODERATION).getBean())
        ));
    }
}
