package ru.yandex.autotests.directapi.banners.tags.getbannerstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.BUG)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
@Description("Получить метки баннеров: несовместимостей полей")
public class GetBannersTagsFieldsConflictsTestFailed {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long bannerID;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("DIRECT-36633")
//    @Title("Вызов метода одновременно с "+BannersRequestInfoMap.BANNER_IDS+" и "+BannersRequestInfoMap.CAMPAIGN_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8584")
    public void getBannersTagsWithBannerIdsAndCampaignIds() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(bannerID)
                        .withCampaignIDS(campaignId.intValue()).getBean(),
                new AxisError(71, AxisErrorDetails.BANNERIDS_OR_CAMPAIGNIDS_MUST_NOT_BE_EMPTY));
    }
}
