package ru.yandex.autotests.directapi.banners.tags.getbannerstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 06.08.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(BannerFeatures.GET_BANNERS_TAGS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями. MCB")
public class GetBannersTagsForMcbCampaignNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static final String TAG_FOR_TEXT = "tagForTextCamp";
    private static int[] nonTextTagsIDS;
    private static int[] textTagsIDS;
    private static Long nonTextBannerId;
    private static Long textBannerId;
    private BannerTagsInfo[] bannerTagsInfos;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createNonTextAndTextCampaigns() {
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        nonTextBannerId = api.userSteps.addCompletedAdGroupAndReturnAdId(nonTextCampaignId);
        nonTextTagsIDS = api.userSteps.tagSteps().addTags(nonTextCampaignId, TAG_FOR_MOBILE);
        api.userSteps.tagSteps().updateBannerTags(nonTextBannerId, nonTextTagsIDS[0]);
        assumeThat("метка создалась", nonTextTagsIDS.length, equalTo(1));

        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textBannerId = api.userSteps.addCompletedAdGroupAndReturnAdId(textCampaignId);
        textTagsIDS = api.userSteps.tagSteps().addTags(textCampaignId, TAG_FOR_TEXT);
        api.userSteps.tagSteps().updateBannerTags(textBannerId, textTagsIDS[0]);
        assumeThat("метка создалась", textTagsIDS.length, equalTo(1));
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(BannerLogins.CLIENT_SELF).campaignsSteps()
                .setType(nonTextCampaignId, CampaignsType.mcb);
    }

    @Test
    public void getNonTextCampaignTagsByCampaignID() {
        api.userSteps.tagSteps().shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                new BannersRequestInfoMap(api.type())
                        .withCampaignIDS(nonTextCampaignId.intValue()),
                new AxisError(3500)
        );
    }


    @Test
    public void getNonTextAndTextCampaignsTagsByCampaignID() {
        api.userSteps.tagSteps().shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                new BannersRequestInfoMap(api.type())
                        .withCampaignIDS(nonTextCampaignId.intValue(), textCampaignId.intValue()),
                new AxisError(3500)
        );
    }


    @Test
    public void getNonTextCampaignTagsByBannerID() {
        bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(nonTextBannerId)
        );
        assertThat("вернулась одна метка", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(nonTextBannerId)
                        .withTags(nonTextTagsIDS[0]).getBean()}));
    }


    @Test
    public void getNonTextAndTextCampaignsTagsByBannerID() {
        bannerTagsInfos = sort(api.userSteps.tagSteps().getBannersTags(new BannersRequestInfoMap(api.type())
                        .withBannerIDS(nonTextBannerId, textBannerId)),
                on(BannerTagsInfo.class).getBannerID()).toArray(new BannerTagsInfo[0]);
        assertThat("результат соответствует ожидаемому", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(nonTextBannerId)
                        .withTags(nonTextTagsIDS[0]).getBean(),
                new BannerTagsInfoMap(api.type())
                        .withBannerID(textBannerId)
                        .withTags(textTagsIDS[0]).getBean()}));
    }
}
