package ru.yandex.autotests.directapi.banners.tags.getbannerstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 26.07.16.
 * https://st.yandex-team.ru/TESTIRT-9782
 */
@Aqua.Test
@Features(BannerFeatures.GET_BANNERS_TAGS)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-54756")
@Description("Получение тегов графического баннера")
public class GetBannersTagsImageAdTest {

    private static final String LOGIN = BannerLogins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textCampaignId;
    private static Long textImageAdId;
    private static Long mobileAppCampaignId;
    private static Long mobileAppImageAdId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static final String TAG_FOR_TEXT = "tagForTextCamp";
    private static int textImageAdTag;
    private static int mobileAppImageAdTag;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void prepareData() {
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(12);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
        textImageAdTag = api.userSteps.tagSteps().addTags(textCampaignId.intValue(), TAG_FOR_TEXT)[0];
        api.userSteps.tagSteps().updateBannerTags(textImageAdId, textImageAdTag);
        mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
        mobileAppImageAdTag = api.userSteps.tagSteps().addTags(mobileAppCampaignId.intValue(), TAG_FOR_MOBILE)[0];
        api.userSteps.tagSteps().updateBannerTags(mobileAppImageAdId, mobileAppImageAdTag);
    }

    @Test
    public void getBannersTagsTextImageAd() {
        BannerTagsInfo[] bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(textImageAdId)
        );
        assertThat("вернулась одна метка", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(textImageAdId)
                        .withTags(textImageAdTag).getBean()}));
    }

    @Test
    public void getBannersTagsMobileAppImageAd() {
        BannerTagsInfo[] bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(mobileAppImageAdId)
        );
        assertThat("вернулась одна метка", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(mobileAppImageAdId)
                        .withTags(mobileAppImageAdTag).getBean()}));
    }
}
