package ru.yandex.autotests.directapi.banners.tags.getbannerstags;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.GET_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки баннеров: валидация типов в JSON")
public class GetBannersTagsJsonValidationTest {

    private static final String STRING_VALUE = "stringValue";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long bannerID;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title(BannersRequestInfoMap.CAMPAIGN_IDS + " типа int")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8602")
    public void campaignIdsOfIntegerType() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannersRequestInfoMap.CAMPAIGN_IDS), campaignId);
        api.userSteps.shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                request,
                new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY,
                        capitalize(BannersRequestInfoMap.CAMPAIGN_IDS)));
    }

    @Test
    @Title("Строка в массиве " + BannersRequestInfoMap.CAMPAIGN_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8601")
    public void stringInCampaignIdsArray() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannersRequestInfoMap.CAMPAIGN_IDS), new Object[]{campaignId, STRING_VALUE});
        api.userSteps.shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                request,
                new AxisError(71, AxisErrorDetails.ARRAY_MUST_CONTAIN_POSITIVE_INTEGER_VALUES,
                        capitalize(BannersRequestInfoMap.CAMPAIGN_IDS)));
    }

    @Test
    @Title(BannersRequestInfoMap.BANNER_IDS + " типа int")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8600")
    public void bannerIdsOfIntegerType() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannersRequestInfoMap.BANNER_IDS), bannerID);
        api.userSteps.shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                request,
                new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY,
                        capitalize(BannersRequestInfoMap.BANNER_IDS)));
    }

    @Test
    @Title("Строка в массиве " + BannersRequestInfoMap.BANNER_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8599")
    public void stringInBannerIdsArray() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannersRequestInfoMap.BANNER_IDS), new Object[]{bannerID, STRING_VALUE});
        api.userSteps.shouldGetErrorOn(
                Method.GET_BANNERS_TAGS,
                request,
                new AxisError(71, AxisErrorDetails.ARRAY_MUST_CONTAIN_POSITIVE_INTEGER_VALUES,
                        capitalize(BannersRequestInfoMap.BANNER_IDS)));
    }
}
